% scrambling and encoding

%% Scrambler

% length for PN sequence

nr_input_bits_PN = length(generated_input_before);

% load a stored PN sequence

load PN_Sequence.mat

% repeat the PN sequence until length is sufficient

while length(PN) < nr_input_bits_PN

    PN = [PN;PN];
    
end

% cut out the right PN sequence length

P = PN(1:length(generated_input_before));

% scramble the input

scrambled_bits = xor(generated_input_before, P');


%% Hamming coding

% choose number of parities

nr_parity_bits = 4;

% hamming code the data

[generated_input_hamming, added_number_zeros_hamming] = hamming_coding(scrambled_bits,nr_parity_bits);

% number of bits after hamming encoding

nr_bits_input = length(generated_input_hamming);

%% Interleaving 

% Parameters for interleaving

nr_columns = 1039*9;
nr_rows = nr_bits_input/nr_columns;

% Interleave the data
generated_input_hamming = interleaving(generated_input_hamming,nr_rows,nr_columns );

